"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    // Deep clone note_pages table
    await query.sequelize.query(`
    CREATE TABLE notes (LIKE note_pages INCLUDING ALL);
  `);
    // Add extra columns
    await query.addColumn('notes', 'author_id', {
        type: _sequelize.default.STRING,
        references: {
            model: 'users',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('notes', 'on_behalf_of_id', {
        type: _sequelize.default.STRING,
        references: {
            model: 'users',
            key: 'id'
        },
        allowNull: true
    });
    await query.addColumn('notes', 'revised_by_id', {
        type: _sequelize.default.STRING,
        allowNull: true
    });
    await query.addColumn('notes', 'content', {
        type: _sequelize.default.TEXT,
        allowNull: false,
        defaultValue: ''
    });
}
async function down(query) {
    await query.dropTable('notes');
}

//# sourceMappingURL=1686114022270-migrateNotesV2.js.map