// takes the first 6 bytes of the uuid and creates an integer
// - collision rate of around one per hundred million uuids
// - small enough to fit inside a JS integer
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "uuidToFairlyUniqueInteger", {
    enumerable: true,
    get: function() {
        return uuidToFairlyUniqueInteger;
    }
});
const uuidToFairlyUniqueInteger = (id)=>Number(`0x${id.replaceAll('-', '').substring(0, 12)}`);

//# sourceMappingURL=uuidToFairlyUniqueInteger.js.map