"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "sync", {
    enumerable: true,
    get: function() {
        return sync;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const sync = _express.default.Router();
function resultToMessage({ enabled, queued, ran, timedOut }) {
    if (timedOut) return 'Sync is taking a while, continuing in the background...';
    if (!enabled) return "Sync was disabled and didn't run";
    if (ran) return 'Sync completed';
    if (queued) return 'Sync queued and will run later';
    throw new Error('Unknown sync status');
}
sync.post('/run', (0, _expressasynchandler.default)(async (req, res)=>{
    const { syncConnection, user } = req;
    req.flagPermissionChecked(); // no particular permission check for checking sync status
    const completeSync = ()=>syncConnection.runSync({
            urgent: true,
            type: 'userRequested',
            userId: user.id,
            userEmail: user.email
        });
    const timeoutAfter = (seconds)=>new Promise((resolve)=>{
            setTimeout(()=>resolve({
                    timedOut: true
                }), seconds * 1000);
        });
    const result = await Promise.race([
        completeSync(),
        timeoutAfter(10)
    ]);
    const message = resultToMessage(result);
    res.send({
        message
    });
}));
sync.get('/status', (0, _expressasynchandler.default)(async (req, res)=>{
    const { syncConnection } = req;
    req.flagPermissionChecked(); // no particular permission check for checking sync status
    const status = await syncConnection.getSyncStatus();
    res.send(status);
}));

//# sourceMappingURL=sync.js.map