"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirDosageInstruction", {
    enumerable: true,
    get: function() {
        return FhirDosageInstruction;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _timing = require("./timing");
const _doseAndRate = require("./doseAndRate");
const _codeableConcept = require("./codeableConcept");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirDosageInstruction = class FhirDosageInstruction extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            text: _yup.string().nullable().default(null),
            timing: _timing.FhirTiming.asYup().nullable().default(null),
            doseAndRate: _yup.array().of(_doseAndRate.FhirDoseAndRate.asYup()).nullable().default(null),
            route: _codeableConcept.FhirCodeableConcept.asYup().nullable().default(null)
        }).noUnknown();
    }
    static fake() {
        return new this({
            text: 'Take 1 tablet by mouth',
            timing: _timing.FhirTiming.fake(),
            doseAndRate: [
                _doseAndRate.FhirDoseAndRate.fake()
            ]
        });
    }
};

//# sourceMappingURL=dosageInstruction.js.map