"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FullLabRequestDetailsSection: function() {
        return FullLabRequestDetailsSection;
    },
    MinimalLabRequestDetailsSection: function() {
        return MinimalLabRequestDetailsSection;
    },
    PublishedDetailsRow: function() {
        return PublishedDetailsRow;
    },
    SampleDetailsRow: function() {
        return SampleDetailsRow;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _constants = require("@tamanu/constants");
const _Layout = require("./Layout");
const _Typography = require("./Typography");
const _DataItem = require("./printComponents/DataItem");
const _PrintableBarcode = require("./printComponents/PrintableBarcode");
const _getDisplayDate = require("./getDisplayDate");
const _languageContext = require("../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DATE_TIME_FORMAT = 'dd/MM/yyyy h:mma';
const SampleDetailsRow = ({ request })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.sampleDateTime.label', 'Sample date & time'),
        value: (0, _getDisplayDate.getDisplayDate)(request.sampleTime, DATE_TIME_FORMAT)
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.collectedBy.label', 'Collected by'),
        value: request.collectedBy?.displayName
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.site.label', 'Site'),
        value: request.site?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.specimenType.label', 'Specimen type'),
        value: request.specimenType?.name
    })));
};
const PublishedDetailsRow = ({ request })=>{
    const { getEnumTranslation, getTranslation } = (0, _languageContext.useLanguageContext)();
    const notApplicable = getTranslation('general.fallback.notApplicable', 'N/A', {
        casing: 'lower'
    });
    return /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.publishedDate.label', 'Published date & time'),
        value: request.publishedDate ? (0, _getDisplayDate.getDisplayDate)(request.publishedDate, DATE_TIME_FORMAT) : notApplicable
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.publishedBy.label', 'Published by'),
        value: request.publishedBy?.displayName ?? notApplicable
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.status.label', 'Status'),
        value: getEnumTranslation(_constants.LAB_REQUEST_STATUS_LABELS, request.status)
    })));
};
const MinimalLabRequestDetailsSection = ({ request })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.requestId.label', 'Request ID'),
        value: request.displayId
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.requestedBy.label', 'Requested by'),
        value: request.requestedBy?.displayName
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.requestedDate.label', 'Requested date & time'),
        value: (0, _getDisplayDate.getDisplayDate)(request.requestedDate, DATE_TIME_FORMAT)
    })));
};
const FullLabRequestDetailsSection = ({ request })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const labTestTypeAccessor = ({ labTestPanelRequest, tests })=>{
        if (labTestPanelRequest) {
            return labTestPanelRequest.labTestPanel.name;
        }
        return tests?.map((test)=>test.labTestType?.name).join(', ') || '';
    };
    const notesAccessor = ({ notes })=>{
        return notes?.map((note)=>note?.content || '').filter(Boolean).join(',\n') || '';
    };
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.requestId.label', 'Request ID'),
        value: request.displayId
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.requestedBy.label', 'Requested by'),
        value: request.requestedBy?.displayName
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.priority.label', 'Priority'),
        value: request.priority?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.requestedDate.label', 'Requested date & time'),
        value: (0, _getDisplayDate.getDisplayDate)(request.requestedDate, DATE_TIME_FORMAT)
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.testCategory.label', 'Test category'),
        value: request.category?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('lab.tests.label', 'Tests'),
        value: labTestTypeAccessor(request)
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        mt: 9,
        fontSize: 9,
        bold: true
    }, getTranslation('lab.requestIdBarcode.label', 'Request ID barcode:')), /*#__PURE__*/ _react.default.createElement(_PrintableBarcode.PrintableBarcode, {
        id: request.displayId
    })))), /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.notes.label', 'Notes'),
        value: notesAccessor(request)
    })));
};

//# sourceMappingURL=LabRequestDetailsSection.js.map