"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "renderDataItems", {
    enumerable: true,
    get: function() {
        return renderDataItems;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataItem = require("./DataItem");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const renderDataItems = (fields, patient, getLocalisation, getTranslation, getSetting, fontSize = 9)=>{
    return fields.map(({ key, label: defaultLabel, accessor })=>{
        const value = (accessor ? accessor(patient, {
            getLocalisation,
            getTranslation,
            getSetting
        }) : patient[key]) || '';
        const label = getTranslation(`general.localisedField.${key}.label.short`) || getTranslation(`general.localisedField.${key}.label`) || defaultLabel;
        return /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
            label: label,
            value: value,
            fontSize: fontSize,
            key: key
        });
    });
};

//# sourceMappingURL=renderDataItems.js.map