"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DefaultDataExporter", {
    enumerable: true,
    get: function() {
        return DefaultDataExporter;
    }
});
const _ModelExporter = require("./ModelExporter");
const CUSTOM_TAB_NAMES = {
    patientFieldDefinitionCategory: 'Patient Field Def Category'
};
let DefaultDataExporter = class DefaultDataExporter extends _ModelExporter.ModelExporter {
    async getData() {
        const modelName = this.dataType.charAt(0).toUpperCase() + this.dataType.slice(1);
        const data = await this.models[modelName].findAll();
        return data;
    }
    customTabName() {
        return CUSTOM_TAB_NAMES[this.dataType];
    }
};

//# sourceMappingURL=DefaultDataExporter.js.map