"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "invoiceInsurancePlanItemLoaderFactory", {
    enumerable: true,
    get: function() {
        return invoiceInsurancePlanItemLoaderFactory;
    }
});
const _ProductMatrixByCodeLoaderFactory = require("./ProductMatrixByCodeLoaderFactory");
function invoiceInsurancePlanItemLoaderFactory() {
    return (0, _ProductMatrixByCodeLoaderFactory.productMatrixByCodeLoaderFactory)({
        parentModel: 'InvoiceInsurancePlan',
        itemModel: 'InvoiceInsurancePlanItem',
        parentIdField: 'invoiceInsurancePlanId',
        valueField: 'coverageValue',
        messages: {
            duplicateCode: (code)=>`duplicate insurance plan code: ${code}`,
            missingParentByCode: (code)=>`InvoiceInsurancePlan with code '${code}' does not exist`,
            couldNotFindParentId: (code)=>`Could not find InvoiceInsurancePlan ID for code '${code}'`,
            invalidValue: (raw, code, invoiceProductId)=>`Invalid coverage value '${raw}' for insurancePlan '${code}' and invoiceProductId '${invoiceProductId}'`
        }
    });
}

//# sourceMappingURL=invoiceInsurancePlanItemLoaderFactory.js.map