"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    migrateDeletedRecords: function() {
        return migrateDeletedRecords;
    },
    migrateDeletedRecordsCommand: function() {
        return migrateDeletedRecordsCommand;
    },
    runMigrate: function() {
        return runMigrate;
    }
});
const _commander = require("commander");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("../../database");
const fromSurveyScreenComponent = async ()=>{
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const response = await store.sequelize.query(`UPDATE "survey_screen_components"
      SET "visibility_status" = :historical
      WHERE "deleted_at" IS NOT NULL and "visibility_status" != :historical;
      
      UPDATE "survey_screen_components" 
      SET "deleted_at" = CURRENT_TIMESTAMP
      WHERE "visibility_status" = :historical AND "deleted_at" IS NULL;`, {
        replacements: {
            historical: _constants.VISIBILITY_STATUSES.HISTORICAL
        }
    });
    _logging.log.info(`${response[1].rowCount} soft deleted records updated at survey_screen_components table`);
};
const TABLE_TO_MIGRATION_MAPPING = {
    survey_screen_components: fromSurveyScreenComponent
};
const runMigrate = async (migration, Resource)=>{
    if (!migration) {
        _logging.log.error(`Subcommand migrateDeletedRecords: Resource ${Resource} is not supported`);
        process.exit(1);
    }
    _logging.log.info(`Starting Deleted records migration for ${Resource}...`);
    await migration(Resource);
    _logging.log.info(`Deleted records migration is done`);
};
const migrateDeletedRecords = async ({ migrate: Resource })=>{
    if (Resource === 'all') {
        for (const [resource, migration] of Object.entries(TABLE_TO_MIGRATION_MAPPING)){
            await runMigrate(migration, resource);
        }
        process.exit(0);
    }
    const migration = TABLE_TO_MIGRATION_MAPPING[Resource];
    await runMigrate(migration, Resource);
    process.exit(0);
};
const migrateDeletedRecordsCommand = new _commander.Command('deletedRecords').description('Deleted records migration').option('--migrate <Resource>', 'Deleted records migration for a given resource (use `all` to do migrate all non paranoid resources)').action(migrateDeletedRecords);

//# sourceMappingURL=migrateDeletedRecords.js.map