"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
async function up(query) {
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json for this migration to run.');
    }
    await query.addColumn('lab_requests', 'published_date', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    await query.sequelize.query(`
  UPDATE lab_requests
    SET published_date = TO_CHAR(lrl.created_at::TIMESTAMPTZ AT TIME ZONE '${COUNTRY_TIMEZONE}', '${ISO9075_DATE_TIME_FMT}')
    FROM lab_request_logs lrl
    WHERE lrl.lab_request_id = lab_requests.id AND lrl.status = 'published';
  `);
}
async function down(query) {
    await query.removeColumn('lab_requests', 'published_date');
}

//# sourceMappingURL=1682409691120-addPublishedDateLabRequest.js.map