"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.addIndex('vital_logs', {
        fields: [
            'answer_id'
        ]
    });
    await query.addIndex('survey_response_answers', {
        fields: [
            'body'
        ]
    });
}
async function down(query) {
    await query.removeIndex('vital_logs', [
        'answer_id'
    ]);
    await query.removeIndex('survey_response_answers', [
        'body'
    ]);
}

//# sourceMappingURL=1690523103281-addIndicesToVitalLogsAndSurveyResponseAnswers.js.map