/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('invoice_insurer_payments', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_payment_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoice_payments',
                key: 'id'
            },
            unique: true
        },
        insurer_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        status: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        reason: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('invoice_insurer_payments');
}

//# sourceMappingURL=1720091988656-addInvoiceInsurerPaymentTable.js.map