/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('surveys', 'notifiable', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
    await query.addColumn('surveys', 'notify_email_addresses', {
        type: _sequelize.DataTypes.ARRAY(_sequelize.DataTypes.STRING),
        allowNull: false,
        defaultValue: []
    });
    await query.addColumn('survey_responses', 'notified', {
        type: _sequelize.DataTypes.BOOLEAN,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('surveys', 'notifiable');
    await query.removeColumn('surveys', 'notify_email_addresses');
    await query.removeColumn('survey_responses', 'notified');
}

//# sourceMappingURL=1723950769439-addNotificationFeatureForSurvey.js.map