"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "IPSRequest", {
    enumerable: true,
    get: function() {
        return IPSRequest;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let IPSRequest = class IPSRequest extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            createdBy: _sequelize.DataTypes.STRING,
            email: _sequelize.DataTypes.STRING,
            status: _sequelize.DataTypes.STRING,
            error: _sequelize.DataTypes.TEXT
        }, {
            ...options,
            tableName: 'ips_requests',
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.belongsTo(models.User, {
            foreignKey: 'createdBy',
            as: 'createdByUser'
        });
    }
};

//# sourceMappingURL=IPSRequest.js.map