"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getResetPasswordErrorMessage", {
    enumerable: true,
    get: function() {
        return getResetPasswordErrorMessage;
    }
});
const _constants = require("./constants");
const _BaseError = require("./BaseError");
function getResetPasswordErrorMessage(error) {
    if (error instanceof _BaseError.BaseError) {
        return error.message;
    }
    if (error.type === _constants.ERROR_TYPE.RATE_LIMITED) {
        return `User locked out. ${Math.ceil(error.extra.get('retry-after') / 60)} minute(s) remaining.`;
    }
    return error.message;
}

//# sourceMappingURL=getResetPasswordErrorMessage.js.map