"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateEachDataType", {
    enumerable: true,
    get: function() {
        return generateEachDataType;
    }
});
const _index = require("./helpers/index.js");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const generateEachDataType = async (models)=>{
    const { default: pLimit } = await Promise.resolve().then(()=>/*#__PURE__*/ _interop_require_wildcard(require("p-limit")));
    const limit = pLimit(10);
    // Create one of each basic deployment/reference data to reference for clinical data
    const { referenceData, facility, department, locationGroup, location, survey, scheduledVaccine, invoiceProduct, labTestType, user, programRegistry } = await (0, _index.generateImportData)(models);
    // Clinical data
    const { patient } = await (0, _index.createPatient)({
        models,
        limit,
        facilityId: facility.id,
        userId: user.id
    });
    const { encounter } = await (0, _index.createEncounter)({
        models,
        limit,
        patientId: patient.id,
        departmentId: department.id,
        locationId: location.id,
        userId: user.id,
        referenceDataId: referenceData.id
    });
    await Promise.all([
        await (0, _index.createLabRequest)({
            models,
            limit,
            departmentId: department.id,
            userId: user.id,
            encounterId: encounter.id,
            referenceDataId: referenceData.id,
            patientId: patient.id,
            labTestTypeId: labTestType.id
        }),
        await (0, _index.createProgramRegistry)({
            models,
            limit,
            userId: user.id,
            patientId: patient.id,
            programRegistryId: programRegistry.id
        }),
        await (0, _index.createSurveyResponse)({
            models,
            limit,
            encounterId: encounter.id,
            surveyId: survey.id
        }),
        await (0, _index.createDbReport)({
            models,
            limit,
            userId: user.id
        }),
        await (0, _index.createAdministeredVaccine)({
            models,
            limit,
            scheduledVaccineId: scheduledVaccine.id,
            encounterId: encounter.id
        }),
        await (0, _index.createInvoice)({
            models,
            limit,
            encounterId: encounter.id,
            userId: user.id,
            referenceDataId: referenceData.id,
            productId: invoiceProduct.id
        }),
        await (0, _index.createImagingRequest)({
            models,
            limit,
            userId: user.id,
            encounterId: encounter.id,
            locationGroupId: locationGroup.id
        }),
        await (0, _index.createRepeatingAppointment)({
            models,
            limit,
            locationGroupId: locationGroup.id,
            patientId: patient.id,
            clinicianId: user.id
        }),
        await (0, _index.createTask)({
            models,
            limit,
            encounterId: encounter.id,
            userId: user.id,
            referenceDataId: referenceData.id
        }),
        await (0, _index.createPatientCommunication)({
            models,
            limit,
            patientId: patient.id
        }),
        await (0, _index.createMedication)({
            models,
            limit,
            encounterId: encounter.id,
            patientId: patient.id,
            referenceDataId: referenceData.id
        }),
        await (0, _index.createAccessLog)({
            models,
            limit,
            userId: user.id,
            patientId: patient.id,
            facilityId: facility.id
        })
    ]);
};

//# sourceMappingURL=generateEachDataType.js.map