"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PortalSurveyAssignmentsSchema", {
    enumerable: true,
    get: function() {
        return PortalSurveyAssignmentsSchema;
    }
});
const _constants = require("@tamanu/constants");
const _zod = require("zod");
const _patientschema = require("../../patientPortal/responses/patient.schema");
const _surveyschema = require("./survey.schema");
const _userschema = require("./user.schema");
const PortalSurveyAssignmentsSchema = _zod.z.object({
    id: _zod.z.string(),
    patient: _patientschema.PatientSchema,
    assignedBy: _userschema.UserSchema,
    assignedAt: _zod.z.string(),
    survey: _surveyschema.SurveyWithProgramSchema,
    status: _zod.z.enum(_constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES)
});

//# sourceMappingURL=portalSurveyAssignments.schema.js.map