"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.createTable('refresh_tokens', {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        refresh_id: {
            type: _sequelize.default.TEXT,
            allowNull: false
        },
        device_id: {
            type: _sequelize.default.TEXT,
            allowNull: false
        },
        user_id: {
            type: _sequelize.default.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            }
        },
        expires_at: {
            type: _sequelize.default.DATE,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.default.DATE
        },
        created_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW
        },
        updated_at: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW
        }
    });
    await query.addIndex('refresh_tokens', {
        name: 'refresh_tokens_user_id_device_id',
        fields: [
            'user_id',
            'device_id'
        ],
        unique: true
    });
}
async function down(query) {
    await query.dropTable('refresh_tokens');
}

//# sourceMappingURL=1673478470978-addRefreshTokenTable.js.map