/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const DEFAULT_SETTINGS = {
    [_constants.SETTING_KEYS.INSURER_DEFAUlT_CONTRIBUTION]: JSON.stringify(0.8)
};
async function up(query) {
    if (_config.default.serverFacilityId || _config.default.serverFacilityIds) return;
    await query.bulkInsert('settings', Object.entries(DEFAULT_SETTINGS).map(([key, value])=>({
            key,
            value
        })));
}
async function down(query) {
    if (_config.default.serverFacilityId || _config.default.serverFacilityIds) return;
    await query.bulkDelete('settings', {
        key: {
            [_sequelize.Op.in]: Object.keys(DEFAULT_SETTINGS)
        }
    });
}

//# sourceMappingURL=1715068426127-addDefaultInsurerContributionConfigSetting.js.map