import { type InitOptions, type ModelAttributes } from 'sequelize';
import { Model } from '../Model';
export declare class FhirResource extends Model {
    id: string;
    versionId: string;
    upstreamId: string;
    lastUpdated: Date;
    isLive: boolean;
    resolved: boolean;
    static initResource(attributes: ModelAttributes, options: InitOptions): void;
    static get fhirName(): string;
    static CAN_DO: Set<unknown>;
    static UpstreamModels: (typeof Model)[];
    static upstreams: (typeof Model)[];
    static referencedResources: (typeof Model)[];
    static UPSTREAM_UUID: boolean;
    static INTAKE_SCHEMA: unknown;
    static materialiseFromUpstream(id: string, relatedToId?: string | null): Promise<FhirResource>;
    updateMaterialisation(): Promise<void>;
    updateIsLive(): Promise<void>;
    shouldForceRematerialise(): Promise<boolean>;
    getRelatedUpstreamIds(): Promise<string[]>;
    isUpToDate(): Promise<boolean>;
    getUpstream<T extends Model = Model>(queryOptions?: Record<string, any>): Promise<T | undefined>;
    static resolveUpstreams(): Promise<void>;
    pushUpstream(..._args: any): Promise<InstanceType<typeof Model> | undefined>;
    static queryToFindUpstreamIdsFromTable(_upstreamTable: string, _table: string, _id: string, _deletedRow?: object | null): Promise<object | null>;
    static queryToFilterUpstream(_upstreamTable: string): Promise<object | null>;
    formatFieldsAsFhir(fields: object | object[]): object;
    asFhir(): Record<string, any>;
    /**
     * FHIR search parameter configuration for the Resource.
     */
    static searchParameters(): object;
}
//# sourceMappingURL=Resource.d.ts.map