"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getMetaServerHosts", {
    enumerable: true,
    get: function() {
        return getMetaServerHosts;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getMetaServerHosts = ()=>{
    const metaServerHosts = _config.default?.metaServer?.hosts ?? [
        _config.default?.metaServer?.host
    ];
    if (!Array.isArray(metaServerHosts)) {
        throw new Error('metaServer.hosts is not an array');
    }
    if (metaServerHosts.length === 0) {
        throw new Error('No meta server hosts configured');
    }
    return metaServerHosts;
};

//# sourceMappingURL=getMetaServerHosts.js.map