"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    InvalidConfigError: function() {
        return InvalidConfigError;
    },
    startFhirWorkerTasks: function() {
        return _fhir.startFhirWorkerTasks;
    },
    startScheduledTasks: function() {
        return startScheduledTasks;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _logging = require("@tamanu/shared/services/logging");
const _SendStatusToMetaServer = require("@tamanu/shared/tasks/SendStatusToMetaServer");
const _PatientEmailCommunicationProcessor = require("./PatientEmailCommunicationProcessor");
const _PortalCommunicationProcessor = require("./PortalCommunicationProcessor");
const _PatientMergeMaintainer = require("./PatientMergeMaintainer");
const _OutpatientDischarger = require("./OutpatientDischarger");
const _DeceasedPatientDischarger = require("./DeceasedPatientDischarger");
const _ReportRequestProcessor = require("./ReportRequestProcessor");
const _ReportRequestScheduler = require("./ReportRequestScheduler");
const _VRSActionRetrier = require("./VRSActionRetrier");
const _SignerWorkingPeriodChecker = require("./SignerWorkingPeriodChecker");
const _SignerRenewalChecker = require("./SignerRenewalChecker");
const _SignerRenewalSender = require("./SignerRenewalSender");
const _CertificateNotificationProcessor = require("./CertificateNotificationProcessor");
const _IPSRequestProcessor = require("./IPSRequestProcessor");
const _AutomaticLabTestResultPublisher = require("./AutomaticLabTestResultPublisher");
const _CovidClearanceCertificatePublisher = require("./CovidClearanceCertificatePublisher");
const _PlannedMoveTimeout = require("./PlannedMoveTimeout");
const _StaleSyncSessionCleaner = require("./StaleSyncSessionCleaner");
const _FhirMissingResources = require("./FhirMissingResources");
const _PatientTelegramCommunicationProcessor = require("./PatientTelegramCommunicationProcessor");
const _VaccinationReminderProcessor = require("./VaccinationReminderProcessor");
const _SurveyCompletionNotifierProcessor = require("./SurveyCompletionNotifierProcessor");
const _SyncLookupRefresher = require("./SyncLookupRefresher");
const _GenerateRepeatingTasks = require("./GenerateRepeatingTasks");
const _GenerateRepeatingAppointments = require("./GenerateRepeatingAppointments");
const _GenerateMedicationAdministrationRecords = require("./GenerateMedicationAdministrationRecords");
const _MedicationDiscontinuer = require("./MedicationDiscontinuer");
const _DHIS2IntegrationProcessor = require("./DHIS2IntegrationProcessor");
const _fhir = require("./fhir");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let InvalidConfigError = class InvalidConfigError extends Error {
};
async function startScheduledTasks(context) {
    const taskClasses = [
        _OutpatientDischarger.OutpatientDischarger,
        _DeceasedPatientDischarger.DeceasedPatientDischarger,
        _PatientEmailCommunicationProcessor.PatientEmailCommunicationProcessor,
        _PortalCommunicationProcessor.PortalCommunicationProcessor,
        _ReportRequestProcessor.ReportRequestProcessor,
        _CertificateNotificationProcessor.CertificateNotificationProcessor,
        _IPSRequestProcessor.IPSRequestProcessor,
        _PatientMergeMaintainer.PatientMergeMaintainer,
        _PatientTelegramCommunicationProcessor.PatientTelegramCommunicationProcessor,
        _VaccinationReminderProcessor.VaccinationReminderProcessor,
        _AutomaticLabTestResultPublisher.AutomaticLabTestResultPublisher,
        _CovidClearanceCertificatePublisher.CovidClearanceCertificatePublisher,
        _StaleSyncSessionCleaner.StaleSyncSessionCleaner,
        _PlannedMoveTimeout.PlannedMoveTimeout,
        _FhirMissingResources.FhirMissingResources,
        _SurveyCompletionNotifierProcessor.SurveyCompletionNotifierProcessor,
        _SyncLookupRefresher.SyncLookupRefresher,
        _GenerateRepeatingTasks.GenerateRepeatingTasks,
        _GenerateRepeatingAppointments.GenerateRepeatingAppointments,
        _GenerateMedicationAdministrationRecords.GenerateMedicationAdministrationRecords,
        _MedicationDiscontinuer.MedicationDiscontinuer,
        _DHIS2IntegrationProcessor.DHIS2IntegrationProcessor,
        _SendStatusToMetaServer.SendStatusToMetaServer
    ];
    if (_config.default.integrations.fijiVrs.enabled) {
        taskClasses.push(_VRSActionRetrier.VRSActionRetrier);
    }
    if (_config.default.integrations.signer.enabled) {
        taskClasses.push(_SignerWorkingPeriodChecker.SignerWorkingPeriodChecker, _SignerRenewalChecker.SignerRenewalChecker, _SignerRenewalSender.SignerRenewalSender);
    }
    const reportSchedulers = await getReportSchedulers(context);
    const tasks = [
        ...taskClasses.map((TaskClass)=>{
            try {
                _logging.log.debug(`Starting to initialise scheduled task ${TaskClass.name}`);
                return new TaskClass(context);
            } catch (err) {
                _logging.log.warn('Failed to initialise scheduled task', {
                    name: TaskClass.name,
                    err
                });
                return null;
            }
        }),
        ...reportSchedulers
    ].filter((x)=>x);
    tasks.forEach((t)=>t.beginPolling());
    return ()=>tasks.forEach((t)=>t.cancelPolling());
}
async function getReportSchedulers(context) {
    const systemUser = await context.store.models.User.getSystemUser();
    const schedulers = [];
    for (const options of _config.default.scheduledReports){
        schedulers.push(new _ReportRequestScheduler.ReportRequestScheduler(context, {
            ...options,
            requestedByUserId: systemUser.id
        }));
    }
    return schedulers;
}

//# sourceMappingURL=index.js.map