"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    DEFAULT_REASON_CANCELLED_BY_API: function() {
        return DEFAULT_REASON_CANCELLED_BY_API;
    },
    FHIR_BUNDLE_TYPES: function() {
        return FHIR_BUNDLE_TYPES;
    },
    FHIR_DATETIME_PRECISION: function() {
        return FHIR_DATETIME_PRECISION;
    },
    FHIR_DIAGNOSTIC_REPORT_STATUS: function() {
        return FHIR_DIAGNOSTIC_REPORT_STATUS;
    },
    FHIR_ENCOUNTER_CLASS_CODE: function() {
        return FHIR_ENCOUNTER_CLASS_CODE;
    },
    FHIR_ENCOUNTER_CLASS_DISPLAY: function() {
        return FHIR_ENCOUNTER_CLASS_DISPLAY;
    },
    FHIR_ENCOUNTER_LOCATION_STATUS: function() {
        return FHIR_ENCOUNTER_LOCATION_STATUS;
    },
    FHIR_ENCOUNTER_STATUS: function() {
        return FHIR_ENCOUNTER_STATUS;
    },
    FHIR_IMAGING_STUDY_STATUS: function() {
        return FHIR_IMAGING_STUDY_STATUS;
    },
    FHIR_INTERACTIONS: function() {
        return FHIR_INTERACTIONS;
    },
    FHIR_ISSUE_SEVERITY: function() {
        return FHIR_ISSUE_SEVERITY;
    },
    FHIR_ISSUE_TYPE: function() {
        return FHIR_ISSUE_TYPE;
    },
    FHIR_LOCATION_PHYSICAL_TYPE_CODE: function() {
        return FHIR_LOCATION_PHYSICAL_TYPE_CODE;
    },
    FHIR_LOCATION_PHYSICAL_TYPE_DISPLAY: function() {
        return FHIR_LOCATION_PHYSICAL_TYPE_DISPLAY;
    },
    FHIR_MAX_RESOURCES_PER_PAGE: function() {
        return FHIR_MAX_RESOURCES_PER_PAGE;
    },
    FHIR_PATIENT_LINK_TYPES: function() {
        return FHIR_PATIENT_LINK_TYPES;
    },
    FHIR_REQUEST_INTENT: function() {
        return FHIR_REQUEST_INTENT;
    },
    FHIR_REQUEST_PRIORITY: function() {
        return FHIR_REQUEST_PRIORITY;
    },
    FHIR_REQUEST_STATUS: function() {
        return FHIR_REQUEST_STATUS;
    },
    FHIR_RESOURCE_TYPES: function() {
        return FHIR_RESOURCE_TYPES;
    },
    FHIR_SEARCH_PARAMETERS: function() {
        return FHIR_SEARCH_PARAMETERS;
    },
    FHIR_SEARCH_PREFIXES: function() {
        return FHIR_SEARCH_PREFIXES;
    },
    FHIR_SEARCH_TOKEN_TYPES: function() {
        return FHIR_SEARCH_TOKEN_TYPES;
    },
    HTTP_BODY_DATA_PATHS: function() {
        return HTTP_BODY_DATA_PATHS;
    },
    IPS_REQUEST_STATUSES: function() {
        return IPS_REQUEST_STATUSES;
    },
    SCRUBBED_DATA_MESSAGE: function() {
        return SCRUBBED_DATA_MESSAGE;
    },
    SUPPORTED_CONTENT_TYPES: function() {
        return SUPPORTED_CONTENT_TYPES;
    }
});
const FHIR_INTERACTIONS = {
    INSTANCE: {
        READ: 'resource-read',
        VREAD: 'resource-vread',
        UPDATE: 'resource-update',
        DELETE: 'resource-delete',
        HISTORY: 'resource-history'
    },
    TYPE: {
        CREATE: 'type-create',
        SEARCH: 'type-search',
        HISTORY: 'type-history'
    },
    SYSTEM: {
        CAPABILITIES: 'capabilities',
        TRANSACTION: 'transaction',
        HISTORY: 'system-history',
        SEARCH: 'system-search'
    },
    INTERNAL: {
        MATERIALISE: 'materialise'
    }
};
const FHIR_SEARCH_PARAMETERS = {
    NUMBER: 'number',
    DATE: 'date',
    STRING: 'string',
    TOKEN: 'token',
    REFERENCE: 'reference',
    COMPOSITE: 'composite',
    QUANTITY: 'quantity',
    URI: 'uri',
    SPECIAL: 'special'
};
const FHIR_SEARCH_TOKEN_TYPES = {
    VALUE: 'value',
    CODING: 'coding',
    STRING: 'string',
    BOOLEAN: 'boolean',
    PRESENCE: 'presence'
};
const FHIR_SEARCH_PREFIXES = {
    EQ: 'eq',
    NE: 'ne',
    GT: 'gt',
    LT: 'lt',
    GE: 'ge',
    LE: 'le'
};
const FHIR_PATIENT_LINK_TYPES = {
    REPLACES: 'replaces',
    REPLACED_BY: 'replaced-by',
    SEE_ALSO: 'seealso'
};
const FHIR_MAX_RESOURCES_PER_PAGE = 20;
const FHIR_DATETIME_PRECISION = {
    SECONDS_WITH_TIMEZONE: 's+tz',
    MINUTES_WITH_TIMEZONE: 'm+tz',
    HOURS_WITH_TIMEZONE: 'h+tz',
    SECONDS: 's',
    MINUTES: 'm',
    HOURS: 'h',
    DAYS: 'D',
    MONTHS: 'M',
    YEARS: 'Y'
};
const FHIR_BUNDLE_TYPES = {
    DOCUMENT: 'document',
    MESSAGE: 'message',
    TRANSACTION: 'transaction',
    TRANSACTION_RESPONSE: 'transaction-response',
    BATCH: 'batch',
    BATCH_RESPONSE: 'batch-response',
    HISTORY: 'history',
    SEARCHSET: 'searchset',
    COLLECTION: 'collection'
};
const FHIR_RESOURCE_TYPES = {
    BUNDLE: 'Bundle',
    COMPOSITION: 'Composition',
    PATIENT: 'Patient',
    MEDICATION_STATEMENT: 'MedicationStatement',
    ALLERGY_INTOLERANCE: 'AllergyIntolerance',
    CONDITION: 'Condition',
    IMMUNIZATION: 'Immunization'
};
const FHIR_ISSUE_SEVERITY = {
    INFORMATION: 'information',
    WARNING: 'warning',
    ERROR: 'error',
    FATAL: 'fatal'
};
const FHIR_ISSUE_TYPE = {
    INVALID: {
        _: 'invalid',
        STRUCTURE: 'structure',
        REQUIRED: 'required',
        VALUE: 'value',
        INVARIANT: 'invariant'
    },
    SECURITY: {
        _: 'security',
        LOGIN: 'login',
        UNKNOWN: 'unknown',
        EXPIRED: 'expired',
        FORBIDDEN: 'forbidden',
        SUPPRESSED: 'suppressed'
    },
    PROCESSING: {
        _: 'processing',
        NOT_SUPPORTED: 'not-supported',
        DUPLICATE: 'duplicate',
        MULTIPLE_MATCHES: 'multiple-matches',
        NOT_FOUND: {
            _: 'not-found',
            DELETED: 'deleted'
        },
        TOO_LONG: 'too-long',
        CODE_INVALID: 'code-invalid',
        EXTENSION: 'extension',
        TOO_COSTLY: 'too-costly',
        BUSINESS_RULE: 'business-rule',
        CONFLICT: 'conflict'
    },
    TRANSIENT: {
        _: 'transient',
        LOCK_ERROR: 'lock-error',
        NO_STORE: 'no-store',
        EXCEPTION: 'exception',
        TIMEOUT: 'timeout',
        INCOMPLETE: 'incomplete',
        THROTTLED: 'throttled'
    },
    INFORMATIONAL: 'informational'
};
const FHIR_REQUEST_STATUS = {
    DRAFT: 'draft',
    ACTIVE: 'active',
    ON_HOLD: 'on-hold',
    REVOKED: 'revoked',
    COMPLETED: 'completed',
    ENTERED_IN_ERROR: 'entered-in-error',
    UNKNOWN: 'unknown'
};
const FHIR_REQUEST_INTENT = {
    PROPOSAL: 'proposal',
    PLAN: 'plan',
    DIRECTIVE: 'directive',
    ORDER: {
        _: 'order',
        ORIGINAL: 'original-order',
        REFLEX: 'reflex-order',
        FILLER: {
            _: 'filler-order',
            INSTANCE: 'instance-order'
        }
    },
    OPTION: 'option'
};
const FHIR_REQUEST_PRIORITY = {
    ROUTINE: 'routine',
    URGENT: 'urgent',
    ASAP: 'asap',
    STAT: 'stat'
};
const FHIR_DIAGNOSTIC_REPORT_STATUS = {
    REGISTERED: 'registered',
    PARTIAL: {
        _: 'partial',
        PRELIMINARY: 'preliminary',
        MODIFIED: 'modified'
    },
    FINAL: 'final',
    AMENDED: {
        _: 'amended',
        CORRECTED: 'corrected',
        APPENDED: 'appended'
    },
    CANCELLED: 'cancelled',
    ENTERED_IN_ERROR: 'entered-in-error',
    UNKNOWN: 'unknown'
};
const FHIR_IMAGING_STUDY_STATUS = {
    REGISTERED: 'registered',
    AVAILABLE: 'available',
    FINAL_INVALID_LEGACY: 'final',
    CANCELLED: 'cancelled',
    ENTERED_IN_ERROR: 'entered-in-error',
    UNKNOWN: 'unknown'
};
const FHIR_ENCOUNTER_CLASS_DISPLAY = {
    IMP: 'inpatient encounter',
    AMB: 'ambulatory encounter',
    OBSENC: 'observation encounter',
    EMER: 'emergency',
    HH: 'home health',
    VR: 'virtual'
};
const FHIR_ENCOUNTER_CLASS_CODE = Object.fromEntries(Object.keys(FHIR_ENCOUNTER_CLASS_DISPLAY).map((k)=>[
        k,
        k
    ]));
const FHIR_ENCOUNTER_STATUS = {
    PLANNED: 'planned',
    IN_PROGRESS: 'in-progress',
    ON_HOLD: 'on-hold',
    DISCHARGED: 'discharged',
    COMPLETED: 'completed',
    CANCELLED: 'cancelled',
    DISCONTINUED: 'discontinued',
    ENTERED_IN_ERROR: 'entered-in-error',
    UNKNOWN: 'unknown'
};
const FHIR_ENCOUNTER_LOCATION_STATUS = {
    PLANNED: 'planned',
    ACTIVE: 'active',
    RESERVED: 'reserved',
    COMPLETED: 'completed'
};
const FHIR_LOCATION_PHYSICAL_TYPE_CODE = {
    SITE: 'si',
    BUILDING: 'bu',
    WING: 'wi',
    WARD: 'wa',
    LEVEL: 'lvl',
    CORRIDOR: 'co',
    ROOM: 'ro',
    BED: 'bd',
    VEHICLE: 've',
    HOUSE: 'ho',
    CABINET: 'ca',
    ROAD: 'rd',
    AREA: 'area',
    JURISDICTION: 'jdn',
    VIRTUAL: 'vi'
};
const FHIR_LOCATION_PHYSICAL_TYPE_DISPLAY = Object.fromEntries(Object.entries(FHIR_LOCATION_PHYSICAL_TYPE_CODE).map(([k, v])=>[
        v,
        `${k.substring(0, 1).toUpperCase()}${k.substring(1).toLowerCase()}`
    ]));
const IPS_REQUEST_STATUSES = {
    QUEUED: 'Queued',
    PROCESSED: 'Processed',
    ERROR: 'Error',
    IGNORE: 'Ignore'
};
const HTTP_BODY_DATA_PATHS = {
    DIAGNOSTIC_REPORT_ATTACHMENT: '$.presentedForm[*].data'
};
const SCRUBBED_DATA_MESSAGE = 'Raw data removed from logs';
const SUPPORTED_CONTENT_TYPES = {
    PDF: 'application/pdf'
};
const DEFAULT_REASON_CANCELLED_BY_API = 'cancelled externally via api';

//# sourceMappingURL=fhir.js.map