import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS, VISIBILITY_STATUSES } from '@tamanu/constants';
import { Model } from '../Model';
export class InvoiceProduct extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: {
                type: DataTypes.TEXT,
                allowNull: false
            },
            discountable: {
                type: DataTypes.BOOLEAN,
                allowNull: false
            },
            category: {
                type: DataTypes.STRING,
                allowNull: true
            },
            sourceRecordType: {
                type: DataTypes.STRING,
                allowNull: true
            },
            sourceRecordId: {
                type: DataTypes.STRING,
                allowNull: true
            },
            visibilityStatus: {
                type: DataTypes.STRING,
                allowNull: false,
                defaultValue: VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'sourceRecordId',
            as: 'sourceRefDataRecord'
        });
        this.belongsTo(models.LabTestPanel, {
            foreignKey: 'sourceRecordId',
            as: 'sourceLabTestPanelRecord'
        });
        this.belongsTo(models.LabTestType, {
            foreignKey: 'sourceRecordId',
            as: 'sourceLabTestTypeRecord'
        });
        // Has many in the context of importing and storing data
        this.hasMany(models.InvoicePriceListItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoicePriceListItems'
        });
        // Has one in the context of fetching data from the api
        this.hasOne(models.InvoicePriceListItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoicePriceListItem'
        });
        this.hasMany(models.InvoiceInsurancePlanItem, {
            foreignKey: 'invoiceProductId',
            as: 'invoiceInsurancePlanItems'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        return [
            'invoicePriceListItems'
        ];
    }
}

//# sourceMappingURL=InvoiceProduct.js.map