"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const TABLE = {
    schema: 'fhir',
    tableName: 'immunizations'
};
async function up(query) {
    await query.createTable(TABLE, {
        id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        version_id: {
            type: _sequelize.default.UUID,
            allowNull: false,
            defaultValue: _sequelize.default.fn('uuid_generate_v4')
        },
        upstream_id: {
            type: _sequelize.default.STRING,
            allowNull: false
        },
        last_updated: {
            type: _sequelize.default.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        status: {
            type: _sequelize.default.TEXT,
            allowNull: false
        },
        vaccine_code: {
            type: 'fhir.codeable_concept',
            allowNull: false
        },
        patient: {
            type: 'fhir.reference',
            allowNull: false
        },
        encounter: {
            type: 'fhir.reference',
            allowNull: true
        },
        occurrence_date_time: {
            type: 'date_time_string',
            allowNull: true
        },
        lot_number: {
            type: _sequelize.default.TEXT,
            allowNull: true
        },
        site: {
            type: 'fhir.codeable_concept[]',
            allowNull: false,
            defaultValue: '{}'
        },
        performer: {
            type: 'fhir.immunization_performer[]',
            allowNull: false,
            defaultValue: '{}'
        },
        protocol_applied: {
            type: 'fhir.immunization_protocol_applied[]',
            allowNull: false,
            defaultValue: '{}'
        }
    });
    await query.addIndex(TABLE, [
        'id',
        'version_id'
    ]);
    await query.addIndex(TABLE, [
        'upstream_id'
    ]);
    await query.sequelize.query(`
    CREATE TRIGGER versioning BEFORE UPDATE ON fhir.${TABLE.tableName}
    FOR EACH ROW EXECUTE FUNCTION fhir.trigger_versioning()
  `);
}
async function down(query) {
    await query.dropTable(TABLE);
}

//# sourceMappingURL=150_fhirImmunizationTable.js.map