"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.changeColumn('patient_death_data', 'manner', {
        type: _sequelize.Sequelize.STRING,
        allowNull: true
    });
    await query.changeColumn('patient_death_data', 'fetal_or_infant', {
        type: _sequelize.Sequelize.BOOLEAN,
        allowNull: true
    });
    await query.addColumn('patient_death_data', 'is_final', {
        type: _sequelize.Sequelize.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
    await query.sequelize.query(`
    UPDATE patient_death_data
    SET is_final = TRUE;
  `);
}
async function down(query) {
    await query.changeColumn('patient_death_data', 'manner', {
        type: _sequelize.Sequelize.STRING,
        allowNull: false
    });
    await query.changeColumn('patient_death_data', 'fetal_or_infant', {
        type: _sequelize.Sequelize.BOOLEAN,
        allowNull: false
    });
    await query.removeColumn('patient_death_data', 'is_final');
}

//# sourceMappingURL=1672792163664-modifyPatientDeathDataColumns.js.map