"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('appointments', 'appointment_type_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'reference_data',
            key: 'id'
        }
    });
    await query.renameColumn('appointments', 'type', 'type_legacy');
}
async function down(query) {
    await query.removeColumn('appointments', 'appointment_type_id');
    await query.renameColumn('appointments', 'type_legacy', 'type');
}

//# sourceMappingURL=1729475962495-addAppointmentTypeIdtoAppointments.js.map