"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // Create location_assignment_templates table
    await query.createTable('location_assignment_templates', {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        location_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'locations',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        start_time: {
            type: _sequelize.DataTypes.TIME,
            allowNull: false
        },
        end_time: {
            type: _sequelize.DataTypes.TIME,
            allowNull: false
        },
        repeat_end_date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        repeat_frequency: {
            type: _sequelize.DataTypes.SMALLINT,
            allowNull: false,
            defaultValue: 1
        },
        repeat_unit: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    // Create location_assignments table
    await query.createTable('location_assignments', {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        location_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'locations',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        start_time: {
            type: _sequelize.DataTypes.TIME,
            allowNull: false
        },
        end_time: {
            type: _sequelize.DataTypes.TIME,
            allowNull: false
        },
        template_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: true,
            references: {
                model: 'location_assignment_templates',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.Sequelize.fn('now')
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('location_assignments');
    await query.dropTable('location_assignment_templates', {});
}

//# sourceMappingURL=1753763535916-createLocationAssignmentTables.js.map