"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.addColumn('invoice_products', 'category', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.addColumn('invoice_products', 'source_record_type', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.addColumn('invoice_products', 'source_record_id', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.addConstraint('invoice_products', {
        fields: [
            'source_record_id',
            'source_record_type'
        ],
        type: 'unique',
        name: 'invoice_products_source_record_id_source_record_type_unique'
    });
    await query.removeColumn('invoice_products', 'price');
    await query.sequelize.query(`SELECT flag_lookup_model_to_rebuild('invoice_products');`);
}
async function down(query) {
    await query.removeConstraint('invoice_products', 'invoice_products_source_record_id_source_record_type_unique');
    await query.removeColumn('invoice_products', 'source_record_type');
    await query.removeColumn('invoice_products', 'source_record_id');
    await query.addColumn('invoice_products', 'price', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: false
    });
    await query.sequelize.query(`SELECT flag_lookup_model_to_rebuild('invoice_products');`);
}

//# sourceMappingURL=1761029255581-UpdateInvoiceProductModelToUsePriceLists.js.map