"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PortalUser", {
    enumerable: true,
    get: function() {
        return PortalUser;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let PortalUser = class PortalUser extends _Model.Model {
    forResponse() {
        return Object.assign({}, this.dataValues);
    }
    static async getForAuthByEmail(email) {
        const user = await this.findOne({
            where: {
                // email addresses are case insensitive so compare them as such
                email: _sequelize.Sequelize.where(_sequelize.Sequelize.fn('lower', _sequelize.Sequelize.col('email')), _sequelize.Sequelize.fn('lower', email)),
                visibilityStatus: _constants.VISIBILITY_STATUSES.CURRENT
            }
        });
        if (!user) {
            return null;
        }
        return user;
    }
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            email: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                unique: true
            },
            patientId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false,
                references: {
                    model: 'patients',
                    key: 'id'
                }
            },
            visibilityStatus: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            },
            status: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.PORTAL_USER_STATUSES.PENDING,
                allowNull: false
            }
        }, {
            ...options,
            indexes: [],
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        this.hasMany(models.PortalOneTimeToken, {
            foreignKey: 'portalUserId',
            as: 'oneTimeTokens'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=PortalUser.js.map