"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Program", {
    enumerable: true,
    get: function() {
        return Program;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Program = class Program extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: _sequelize.DataTypes.STRING,
            name: _sequelize.DataTypes.STRING
        }, {
            ...options,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ],
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static getListReferenceAssociations() {
        return [
            {
                association: 'programRegistries'
            }
        ];
    }
    static initRelations(models) {
        this.hasMany(models.Survey, {
            as: 'surveys',
            foreignKey: 'programId'
        });
        this.hasMany(models.ProgramRegistry, {
            as: 'programRegistries',
            foreignKey: 'programId'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Program.js.map