"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceMedicationTemplate", {
    enumerable: true,
    get: function() {
        return ReferenceMedicationTemplate;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ReferenceMedicationTemplate = class ReferenceMedicationTemplate extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            isOngoing: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            isPrn: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            isVariableDose: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: false,
                defaultValue: false
            },
            doseAmount: _sequelize.DataTypes.DECIMAL,
            units: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            frequency: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            route: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            durationValue: _sequelize.DataTypes.DECIMAL,
            durationUnit: _sequelize.DataTypes.STRING,
            notes: _sequelize.DataTypes.STRING,
            dischargeQuantity: _sequelize.DataTypes.INTEGER
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'medicationId',
            as: 'medication'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ReferenceMedicationTemplate.js.map