import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import type { ProgramDataElement } from './ProgramDataElement';
export declare class SurveyScreenComponent extends Model {
    id: string;
    screenIndex?: number;
    componentIndex?: number;
    text?: string;
    visibilityCriteria?: string;
    validationCriteria?: string;
    detail?: string;
    config?: string;
    options?: string;
    calculation?: string;
    visibilityStatus?: string;
    surveyId?: string;
    dataElementId?: string;
    dataElement?: ProgramDataElement;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(includeAllVitals: any): {
        model: typeof ProgramDataElement;
        as: string;
        paranoid: boolean;
    };
    static initRelations(models: Models): void;
    static getComponentsForSurveys(surveyIds: string[], options?: {
        includeAllVitals?: boolean;
    }): Promise<any[]>;
    static getComponentsForSurvey(surveyId: string, options?: {}): Promise<any[]>;
    forResponse(): any;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): Promise<null>;
}
//# sourceMappingURL=SurveyScreenComponent.d.ts.map