"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "pushOutgoingChanges", {
    enumerable: true,
    get: function() {
        return pushOutgoingChanges;
    }
});
const _calculatePageLimit = require("./calculatePageLimit");
const pushOutgoingChanges = async (centralServer, sessionId, changes)=>{
    let startOfPage = 0;
    let limit = (0, _calculatePageLimit.calculatePageLimit)();
    while(startOfPage < changes.length){
        const endOfPage = Math.min(startOfPage + limit, changes.length);
        const page = changes.slice(startOfPage, endOfPage);
        const startTime = Date.now();
        await centralServer.push(sessionId, page);
        const endTime = Date.now();
        startOfPage = endOfPage;
        limit = (0, _calculatePageLimit.calculatePageLimit)(limit, endTime - startTime);
    }
    await centralServer.completePush(sessionId);
};

//# sourceMappingURL=pushOutgoingChanges.js.map