"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createPatientFilters", {
    enumerable: true,
    get: function() {
        return createPatientFilters;
    }
});
const _datefns = require("date-fns");
const _dateTime = require("@tamanu/utils/dateTime");
const _constants = require("@tamanu/constants");
const _query = require("./query");
const createPatientFilters = (filterParams)=>{
    const filters = [
        (0, _query.makeFilter)(filterParams.displayId, `(UPPER(patients.display_id) LIKE UPPER(:displayId)${filterParams.matchSecondaryIds === 'true' ? ' OR UPPER(:secondaryDisplayId) = ANY(UPPER(secondary_ids::text)::text[])' : ''})`, ({ displayId })=>({
                displayId: `%${displayId}%`,
                secondaryDisplayId: displayId
            })),
        (0, _query.makeFilter)(filterParams.firstName, `UPPER(patients.first_name) LIKE UPPER(:firstName)`, ({ firstName })=>({
                firstName: `%${firstName}%`
            })),
        (0, _query.makeFilter)(filterParams.lastName, `UPPER(patients.last_name) LIKE UPPER(:lastName)`, ({ lastName })=>({
                lastName: `%${lastName}%`
            })),
        (0, _query.makeFilter)(filterParams.culturalName, `UPPER(patients.cultural_name) LIKE UPPER(:culturalName)`, ({ culturalName })=>({
                culturalName: `${culturalName}%`
            })),
        (0, _query.makeFilter)(!filterParams.deceased || filterParams.deceased === 'false', `patients.date_of_death IS NULL`),
        // For age filter
        (0, _query.makeFilter)(filterParams.ageMax, `patients.date_of_birth >= :dobMin`, ({ ageMax })=>({
                // Subtract the number of years, but add one day
                dobMin: (0, _dateTime.toDateString)((0, _datefns.sub)(new Date(), {
                    years: ageMax + 1,
                    days: -1
                }))
            })),
        (0, _query.makeFilter)(filterParams.ageMin, `patients.date_of_birth <= :dobMax`, ({ ageMin })=>({
                dobMax: (0, _dateTime.toDateString)((0, _datefns.sub)(new Date(), {
                    years: ageMin
                }))
            })),
        // For DOB filter
        (0, _query.makeFilter)(filterParams.dateOfBirthFrom, `patients.date_of_birth >= :dateOfBirthFrom`),
        (0, _query.makeFilter)(filterParams.dateOfBirthTo, `patients.date_of_birth<= :dateOfBirthTo`),
        (0, _query.makeFilter)(filterParams.dateOfBirthExact, `patients.date_of_birth = :dateOfBirthExact`),
        (0, _query.makeFilter)(filterParams.villageId, `patients.village_id = :villageId`),
        (0, _query.makeFilter)(filterParams.locationId, `location.id = :locationId`),
        (0, _query.makeFilter)(filterParams.locationGroupId, `location_group.id = :locationGroupId`),
        (0, _query.makeFilter)(filterParams.departmentId, `department.id = :departmentId`),
        (0, _query.makeFilter)(!filterParams.isAllPatientsListing && filterParams.facilityId, `location.facility_id = :facilityId`),
        (0, _query.makeFilter)(filterParams.inpatient, `encounters.encounter_type = 'admission'`),
        (0, _query.makeFilter)(filterParams.outpatient, `encounters.encounter_type = 'clinic'`),
        (0, _query.makeFilter)(filterParams.clinicianId, `encounters.examiner_id = :clinicianId`),
        (0, _query.makeFilter)(filterParams.dietId, `EXISTS (
    SELECT 1
    FROM jsonb_array_elements(diets.diets) elem
    WHERE elem->>'id' = :dietId
)`),
        (0, _query.makeFilter)(filterParams.sex, `patients.sex = :sex`),
        (0, _query.makeFilter)(filterParams.currentPatient, `encounters.encounter_type NOT IN (:currentPatientExcludeEncounterTypes)`, ()=>({
                currentPatientExcludeEncounterTypes: [
                    _constants.ENCOUNTER_TYPES.IMAGING,
                    _constants.ENCOUNTER_TYPES.SURVEY_RESPONSE,
                    _constants.ENCOUNTER_TYPES.VACCINATION
                ]
            })),
        (0, _query.makeDeletedAtIsNullFilter)('encounters'),
        (0, _query.makeDeletedAtIsNullFilter)('patients')
    ].filter((f)=>f);
    return filters;
};

//# sourceMappingURL=patientFilters.js.map