import * as z$1 from "zod/v4/core";
import { z } from "zod";

//#region src/lib/v4/semantics.d.ts
type SemanticFlag$1 = "unspecified" | "key" | "fullname" | "firstname" | "lastname" | "street" | "city" | "country" | "paragraph" | "sentence" | "word" | "phoneNumber" | "age" | "zip" | "jobtitle" | "color" | "color-hex" | "age" | "year" | "month" | "day-of-the-month" | "hour" | "minute" | "second" | "millisecond" | "weekday" | "birthday" | "gender" | "municipality" | "unique-id";
//#endregion
//#region src/lib/v4/generators/numbers.d.ts
type NumberGeneratorOptions$1 = {
  extreme_value_chance: number;
};
//#endregion
//#region src/lib/v4/generators/optional.d.ts
type OptionalOptions$1 = {
  undefined_chance: number;
};
//#endregion
//#region src/lib/v4/generators/nullable.d.ts
type NullableOptions$1 = {
  null_chance: number;
};
//#endregion
//#region src/lib/v4/generators/default.d.ts
type DefaultOptions$1 = {
  default_chance: number;
};
//#endregion
//#region src/lib/v4/generators/map.d.ts
type MapOptions$1 = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v4/generators/record.d.ts
type RecordOptions$1 = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v4/generators/set.d.ts
type SetOptions$1 = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v4/generators/any.d.ts
type AnyOptions$1 = {
  strategy: "true-any" | "json-compatible" | "fast";
};
//#endregion
//#region src/lib/v4/generators/array.d.ts
type ArrayOptions$1 = {
  /** The minimum number of elements, unless specified otherwise */
  min: number;
  /** The maximum number of elements, unless specified otherwise */
  max: number;
};
//#endregion
//#region src/lib/v4/generators/object.d.ts
type ObjectOptions$1 = {
  /** If extra keys should be generated on schemas that allow it. Defaults to true */
  generate_extra_keys: boolean;
};
//#endregion
//#region src/lib/v4/generate.d.ts
/**
 * Contains all the necessary configuration to generate a value for a given schema.
 */
type GenerationContext$1<Z extends z$1.$ZodType> = {
  instanceof_generators: InstanceofGeneratorDefinition$1<any>[];
  reference_generators: ReferenceGeneratorDefinition$1<any>[];
  /** A Map that keeps count of how often we've seen a parent schema - Used for cycle detection */
  parent_schemas: Map<z$1.$ZodType, number>;
  recursion_limit: number;
  path: (string | number | symbol)[];
  semantic_context: SemanticFlag$1;
  seed: number;
  number_options: NumberGeneratorOptions$1;
  optional_options: OptionalOptions$1;
  nullable_options: NullableOptions$1;
  default_options: DefaultOptions$1;
  map_options: MapOptions$1;
  record_options: RecordOptions$1;
  set_options: SetOptions$1;
  any_options: AnyOptions$1;
  unknown_options: AnyOptions$1;
  array_options: ArrayOptions$1;
  object_options: ObjectOptions$1;
};
type Generator$1<Z extends z$1.$ZodType> = (schema: Z, ctx: GenerationContext$1<Z>) => z$1.infer<Z>;
/**
 * Generate a random value that matches the given schema.
 * This get's called recursively until schema generation is done.
 *
 * @param schema - The schema to generate a value for.
 * @param ctx - The context and configuration for the generation process.
 * @returns - A pseudo-random value that matches the given schema.
 */
//#endregion
//#region src/lib/v4/zocker.d.ts
type InstanceofGeneratorDefinition$1<Z extends z$1.$ZodType> = {
  schema: Z;
  generator: Generator$1<Z>;
  /** @deprecated No longer used*/
  match?: "instanceof";
};
type ReferenceGeneratorDefinition$1<Z extends z$1.$ZodType> = {
  schema: Z;
  generator: Generator$1<Z>;
  /** @deprecated No longer used*/
  match?: "reference";
};
declare class Zocker<Z extends z$1.$ZodType> {
  schema: Z;
  private instanceof_generators;
  private reference_generators;
  private seed;
  private recursion_limit;
  private number_options;
  private optional_options;
  private nullable_options;
  private default_options;
  private map_options;
  private record_options;
  private set_options;
  private any_options;
  private unknown_options;
  private array_options;
  private object_options;
  constructor(schema: Z);
  /**
   * Supply your own value / function for generating values for a given schema
   * It will be used whenever the given schema matches an encountered schema by referebce
   *
   * @param schema - The schema for which this value will be used
   * @param generator - A value, or a function that generates a value that matches the schema
   */
  supply<S extends z$1.$ZodType>(schema: S, generator: Generator$1<S> | z$1.infer<S>): Zocker<Z>;
  /**
   * Override one of the built-in generators using your own.
   * It will be used whenever an encoutntered Schema matches the one specified by **instance**
   *
   * @param schema - Which schema to override. E.g: `z.ZodNumber`.
   * @param generator - A value, or a function that generates a value that matches the schema
   */
  override<S extends z$1.$ZodTypes | KNOWN_OVERRIDE_NAMES$1 | z$1.$constructor<any>>(schema: S, generator: Generator$1<S extends KNOWN_OVERRIDE_NAMES$1 ? OVERRIDE$1<S> : S extends z$1.$constructor<infer T> ? T : S> | z$1.infer<S extends KNOWN_OVERRIDE_NAMES$1 ? OVERRIDE$1<S> : S extends z$1.$constructor<infer T> ? T : S>): Zocker<Z>;
  setSeed(seed: number): Zocker<Z>;
  setDepthLimit(limit: number): Zocker<Z>;
  number(options: Partial<NumberGeneratorOptions$1>): Zocker<Z>;
  optional(options: Partial<OptionalOptions$1>): Zocker<Z>;
  nullable(options: Partial<NullableOptions$1>): Zocker<Z>;
  default(options: Partial<DefaultOptions$1>): Zocker<Z>;
  map(options: Partial<MapOptions$1>): Zocker<Z>;
  record(options: Partial<RecordOptions$1>): Zocker<Z>;
  set(options: Partial<SetOptions$1>): Zocker<Z>;
  any(options: Partial<AnyOptions$1>): Zocker<Z>;
  unknown(options: Partial<AnyOptions$1>): Zocker<Z>;
  array(options: Partial<ArrayOptions$1>): Zocker<Z>;
  object(options: Partial<ObjectOptions$1>): Zocker<Z>;
  generate(): z$1.infer<Z>;
  generateMany(count: number): z$1.infer<Z>[];
  private clone;
}
declare const OVERRIDE_NAMES$1: {
  readonly number: z$1.$ZodNumber;
  readonly string: z$1.$ZodString;
  readonly boolean: z$1.$ZodBoolean;
  readonly bigint: z$1.$ZodBigInt;
  readonly date: z$1.$ZodDate;
  readonly undefined: z$1.$ZodUndefined;
  readonly null: z$1.$ZodNull;
  readonly any: z$1.$ZodAny;
  readonly unknown: z$1.$ZodUnknown;
  readonly void: z$1.$ZodVoid;
  readonly never: z$1.$ZodNever;
  readonly array: z$1.$ZodArray<any>;
  readonly object: z$1.$ZodObject<any>;
  readonly union: z$1.$ZodUnion<any>;
  readonly intersection: z$1.$ZodIntersection<any, any>;
  readonly tuple: z$1.$ZodTuple<any>;
  readonly record: z$1.$ZodRecord<any>;
  readonly map: z$1.$ZodMap<any, any>;
  readonly set: z$1.$ZodSet<any>;
  readonly lazy: z$1.$ZodLazy<any>;
  readonly literal: z$1.$ZodLiteral<any>;
  readonly enum: z$1.$ZodEnum<any>;
  readonly promise: z$1.$ZodPromise<any>;
  readonly transformer: z$1.$ZodTransform<any, any>;
  readonly optional: z$1.$ZodOptional<any>;
  readonly nullable: z$1.$ZodNullable<any>;
};
type KNOWN_OVERRIDE_NAMES$1 = keyof typeof OVERRIDE_NAMES$1;
type OVERRIDE$1<NAME extends KNOWN_OVERRIDE_NAMES$1> = (typeof OVERRIDE_NAMES$1)[NAME];
//#endregion
//#region src/lib/v3/semantics.d.ts
type SemanticFlag = "unspecified" | "key" | "fullname" | "firstname" | "lastname" | "street" | "city" | "country" | "paragraph" | "sentence" | "word" | "phoneNumber" | "age" | "zip" | "jobtitle" | "color" | "color-hex" | "age" | "year" | "month" | "day-of-the-month" | "hour" | "minute" | "second" | "millisecond" | "weekday" | "birthday" | "unique-id";
//#endregion
//#region src/lib/v3/generators/numbers.d.ts
type NumberGeneratorOptions = {
  extreme_value_chance: number;
};
//#endregion
//#region src/lib/v3/generators/optional.d.ts
type OptionalOptions = {
  undefined_chance: number;
};
//#endregion
//#region src/lib/v3/generators/nullable.d.ts
type NullableOptions = {
  null_chance: number;
};
//#endregion
//#region src/lib/v3/generators/default.d.ts
type DefaultOptions = {
  default_chance: number;
};
//#endregion
//#region src/lib/v3/generators/map.d.ts
type MapOptions = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v3/generators/record.d.ts
type RecordOptions = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v3/generators/set.d.ts
type SetOptions = {
  max: number;
  min: number;
};
//#endregion
//#region src/lib/v3/generators/any.d.ts
type AnyOptions = {
  strategy: "true-any" | "json-compatible" | "fast";
};
//#endregion
//#region src/lib/v3/generators/array.d.ts
type ArrayOptions = {
  /** The minimum number of elements, unless specified otherwise */
  min: number;
  /** The maximum number of elements, unless specified otherwise */
  max: number;
};
//#endregion
//#region src/lib/v3/generators/object.d.ts
type ObjectOptions = {
  /** If extra keys should be generated on schemas that allow it. Defaults to true */
  generate_extra_keys: boolean;
};
//#endregion
//#region src/lib/v3/generate.d.ts
/**
 * Contains all the necessary configuration to generate a value for a given schema.
 */
type GenerationContext<Z extends z.ZodSchema> = {
  instanceof_generators: InstanceofGeneratorDefinition<any>[];
  reference_generators: ReferenceGeneratorDefinition<any>[];
  /** A Map that keeps count of how often we've seen a parent schema - Used for cycle detection */
  parent_schemas: Map<z.ZodSchema, number>;
  recursion_limit: number;
  path: (string | number | symbol)[];
  semantic_context: SemanticFlag;
  seed: number;
  number_options: NumberGeneratorOptions;
  optional_options: OptionalOptions;
  nullable_options: NullableOptions;
  default_options: DefaultOptions;
  map_options: MapOptions;
  record_options: RecordOptions;
  set_options: SetOptions;
  any_options: AnyOptions;
  unknown_options: AnyOptions;
  array_options: ArrayOptions;
  object_options: ObjectOptions;
};
type Generator<Z extends z.ZodSchema> = (schema: Z, ctx: GenerationContext<Z>) => z.infer<Z>;
/**
 * Generate a random value that matches the given schema.
 * This get's called recursively until schema generation is done.
 *
 * @param schema - The schema to generate a value for.
 * @param ctx - The context and configuration for the generation process.
 * @returns - A pseudo-random value that matches the given schema.
 */
//#endregion
//#region src/lib/v3/zocker.d.ts
type InstanceofGeneratorDefinition<Z extends z.ZodSchema> = {
  schema: Z;
  generator: Generator<Z>;
  /** @deprecated No longer used*/
  match?: "instanceof";
};
type ReferenceGeneratorDefinition<Z extends z.ZodSchema> = {
  schema: Z;
  generator: Generator<Z>;
  /** @deprecated No longer used*/
  match?: "reference";
};
declare class Zocker$1<Z extends z.ZodSchema> {
  schema: Z;
  private instanceof_generators;
  private reference_generators;
  private seed;
  private recursion_limit;
  private number_options;
  private optional_options;
  private nullable_options;
  private default_options;
  private map_options;
  private record_options;
  private set_options;
  private any_options;
  private unknown_options;
  private array_options;
  private object_options;
  constructor(schema: Z);
  /**
   * Supply your own value / function for generating values for a given schema
   * It will be used whenever the given schema matches an encountered schema by referebce
   *
   * @param schema - The schema for which this value will be used
   * @param generator - A value, or a function that generates a value that matches the schema
   */
  supply<S extends z.ZodTypeAny>(schema: S, generator: Generator<S> | z.infer<S>): Zocker$1<Z>;
  /**
   * Override one of the built-in generators using your own.
   * It will be used whenever an encoutntered Schema matches the one specified by **instance**
   *
   * @param schema - Which schema to override. E.g: `z.ZodNumber`.
   * @param generator - A value, or a function that generates a value that matches the schema
   */
  override<S extends z.ZodFirstPartySchemaTypes | KNOWN_OVERRIDE_NAMES>(schema: S, generator: Generator<S extends KNOWN_OVERRIDE_NAMES ? OVERRIDE<S> : S> | z.infer<S extends KNOWN_OVERRIDE_NAMES ? OVERRIDE<S> : S>): Zocker$1<Z>;
  setSeed(seed: number): Zocker$1<Z>;
  setDepthLimit(limit: number): Zocker$1<Z>;
  number(options: Partial<NumberGeneratorOptions>): Zocker$1<Z>;
  optional(options: Partial<OptionalOptions>): Zocker$1<Z>;
  nullable(options: Partial<NullableOptions>): Zocker$1<Z>;
  default(options: Partial<DefaultOptions>): Zocker$1<Z>;
  map(options: Partial<MapOptions>): Zocker$1<Z>;
  record(options: Partial<RecordOptions>): Zocker$1<Z>;
  set(options: Partial<SetOptions>): Zocker$1<Z>;
  any(options: Partial<AnyOptions>): Zocker$1<Z>;
  unknown(options: Partial<AnyOptions>): Zocker$1<Z>;
  array(options: Partial<ArrayOptions>): Zocker$1<Z>;
  object(options: Partial<ObjectOptions>): Zocker$1<Z>;
  generate(): z.infer<Z>;
  generateMany(count: number): z.infer<Z>[];
  private clone;
}
declare const OVERRIDE_NAMES: {
  readonly number: z.ZodNumber;
  readonly string: z.ZodString;
  readonly boolean: z.ZodBoolean;
  readonly bigint: z.ZodBigInt;
  readonly date: z.ZodDate;
  readonly undefined: z.ZodUndefined;
  readonly null: z.ZodNull;
  readonly any: z.ZodAny;
  readonly unknown: z.ZodUnknown;
  readonly void: z.ZodVoid;
  readonly never: z.ZodNever;
  readonly array: z.ZodArray<any>;
  readonly object: z.ZodObject<any>;
  readonly union: z.ZodUnion<any>;
  readonly intersection: z.ZodIntersection<any, any>;
  readonly tuple: z.ZodTuple<any>;
  readonly record: z.ZodRecord<any>;
  readonly map: z.ZodMap<any, any>;
  readonly set: z.ZodSet<any>;
  readonly lazy: z.ZodLazy<any>;
  readonly literal: z.ZodLiteral<any>;
  readonly enum: z.ZodEnum<any>;
  readonly nativeEnum: z.ZodNativeEnum<any>;
  readonly promise: z.ZodPromise<any>;
  readonly transformer: z.ZodTransformer<any, any>;
  readonly optional: z.ZodOptional<any>;
  readonly nullable: z.ZodNullable<any>;
  readonly effects: z.ZodEffects<any, any>;
};
type KNOWN_OVERRIDE_NAMES = keyof typeof OVERRIDE_NAMES;
type OVERRIDE<NAME extends KNOWN_OVERRIDE_NAMES> = (typeof OVERRIDE_NAMES)[NAME];
//#endregion
//#region src/index.d.ts
declare function zocker<Z extends z$1.$ZodType | z.ZodSchema>(schema: Z): Z extends z$1.$ZodType ? Zocker<Z> : Z extends z.ZodSchema ? Zocker$1<Z> : never;
//#endregion
export { zocker };