"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabResultsPrintout", {
    enumerable: true,
    get: function() {
        return LabResultsPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _constants = require("@tamanu/constants");
const _labTests = require("@tamanu/utils/labTests");
const _PatientDetails = require("./printComponents/PatientDetails");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _EncounterDetails = require("./printComponents/EncounterDetails");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _Footer = require("./printComponents/Footer");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _LabRequestDetailsSection = require("./LabRequestDetailsSection");
const _Table = require("./Table");
const _Typography = require("./Typography");
const _patientAccessors = require("../patientAccessors");
const _HorizontalRule = require("./printComponents/HorizontalRule");
const _DoubleHorizontalRule = require("./printComponents/DoubleHorizontalRule");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const generalStyles = _renderer.StyleSheet.create({
    page: {
        paddingBottom: 50
    },
    container: {
        marginVertical: 6
    },
    interimBannerText: {
        border: '1px solid black',
        textAlign: 'center',
        padding: '8px',
        marginHorizontal: '18px'
    },
    tableContainer: {
        marginTop: 8
    },
    tableHeaderStyles: {
        paddingLeft: 6,
        paddingVertical: 8,
        fontSize: 9
    },
    tableColumnStyles: {
        paddingLeft: 6,
        paddingVertical: 4,
        fontSize: 9
    },
    detailsContainer: {
        marginBottom: 5
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestDetailsSection = ({ labRequest })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.detailsContainer
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, getTranslation('pdf.labResults.labRequestDetailsTitle', 'Lab request details')), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_LabRequestDetailsSection.MinimalLabRequestDetailsSection, {
        request: labRequest
    }), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_LabRequestDetailsSection.SampleDetailsRow, {
        request: labRequest
    }), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_LabRequestDetailsSection.PublishedDetailsRow, {
        request: labRequest
    }), /*#__PURE__*/ _react.default.createElement(_DoubleHorizontalRule.DoubleHorizontalRule, null));
};
const InterimBanner = ()=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: generalStyles.interimBannerText,
        fontSize: 14,
        bold: true
    }, getTranslation('pdf.labResults.interimBanner', 'This report contains interim results that have not yet been published'));
};
const LabResultsPrintoutComponent = /*#__PURE__*/ _react.default.memo(({ patientData, encounter, labRequest, certificateData, getLocalisation, getSetting })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const { logo } = certificateData;
    const { tests, labTestPanelRequest } = labRequest;
    const labResultsColumns = [
        {
            key: 'labTestType.name',
            title: getTranslation('lab.results.table.column.testType', 'Test'),
            accessor: ({ labTestType })=>labTestType?.name || ''
        },
        {
            key: 'result',
            title: getTranslation('lab.results.table.column.result', 'Result'),
            accessor: ({ result, labTestType })=>{
                if (result === undefined || result === null || result === '') return '';
                const unit = labTestType?.unit;
                return unit ? `${result} ${unit}` : result;
            }
        },
        {
            key: 'reference',
            title: getTranslation('lab.results.table.column.reference', 'Reference'),
            accessor: ({ labTestType })=>(0, _labTests.getReferenceRangeWithUnit)({
                    labTestType,
                    sex: patientData?.sex,
                    getTranslation
                })
        }
    ];
    /**
     * Currently it is only possible for one panel request per results printout
     * To support multiple panels, we can ensure that rows with the same panel name are ordered together
     * and then use the following to get the groups section label:
     * @example
     * getRowSectionLabel = (row) => row.panelName;
     */ const getRowSectionLabel = ()=>labTestPanelRequest?.labTestPanel?.name;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: [
            _Layout.styles.page,
            generalStyles.page
        ]
    }, tests?.length > 0 && /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: getTranslation('pdf.labResults.documentName', 'Lab results'),
        documentSubname: getTranslation('pdf.labResults.documentSubname', 'Request ID: :requestId', {
            replacements: {
                requestId: labRequest?.displayId || ''
            }
        }),
        patientId: patientData?.displayId || '',
        patientName: (0, _patientAccessors.getName)(patientData)
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: getTranslation('pdf.labResults.documentName', 'Lab results')
    }), _constants.INTERIM_LAB_REQUEST_STATUSES.includes(labRequest.status) && /*#__PURE__*/ _react.default.createElement(InterimBanner, null), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetails.PatientDetails, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_EncounterDetails.EncounterDetails, {
        hideLocation: true,
        encounter: encounter
    }))), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(LabRequestDetailsSection, {
        labRequest: labRequest
    })), tests?.length > 0 && /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, getTranslation('pdf.labResults.testResultsTitle', 'Test results')), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.tableContainer
    }, /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        hideRowDividers: true,
        data: tests,
        columns: labResultsColumns,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        getRowSectionLabel: getRowSectionLabel,
        headerStyle: generalStyles.tableHeaderStyles,
        columnStyle: generalStyles.tableColumnStyles
    }))), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
});
const LabResultsPrintout = (0, _languageContext.withLanguageContext)(LabResultsPrintoutComponent);

//# sourceMappingURL=LabResultsPrintout.js.map