"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SyncLookupRefresher", {
    enumerable: true,
    get: function() {
        return SyncLookupRefresher;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _tasks = require("@tamanu/shared/tasks");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let SyncLookupRefresher = class SyncLookupRefresher extends _tasks.ScheduledTask {
    getName() {
        return `SyncLookupRefresher`;
    }
    async run() {
        await this.context.centralSyncManager.updateLookupTable();
    }
    constructor(context, options){
        const conf = _config.default.schedules.syncLookupRefresher;
        const { schedule, jitterTime, enabled } = conf;
        super(schedule, _logging.log, jitterTime, enabled);
        this.context = context;
        this.models = context.store.models;
        this.options = options;
    }
};

//# sourceMappingURL=SyncLookupRefresher.js.map