"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchParameters", {
    enumerable: true,
    get: function() {
        return searchParameters;
    }
});
const _constants = require("@tamanu/constants");
const searchParameters = {
    identifier: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'identifier',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE
    },
    groupIdentifier: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'groupIdentifier',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.VALUE
    },
    category: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'category',
                'coding',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.CODING
    },
    intent: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'intent'
            ]
        ]
    },
    authoredOn: {
        type: _constants.FHIR_SEARCH_PARAMETERS.DATE,
        path: [
            [
                'authoredOn'
            ]
        ]
    },
    status: {
        type: _constants.FHIR_SEARCH_PARAMETERS.STRING,
        path: [
            [
                'status'
            ]
        ]
    },
    medication: {
        type: _constants.FHIR_SEARCH_PARAMETERS.TOKEN,
        path: [
            [
                'medication',
                'coding',
                '[]'
            ]
        ],
        tokenType: _constants.FHIR_SEARCH_TOKEN_TYPES.CODING
    },
    subject: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'subject'
            ]
        ],
        referenceTypes: [
            'Patient'
        ]
    },
    encounter: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'encounter'
            ]
        ],
        referenceTypes: [
            'Encounter'
        ]
    },
    requester: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'requester'
            ]
        ],
        referenceTypes: [
            'Organization'
        ]
    },
    recorder: {
        type: _constants.FHIR_SEARCH_PARAMETERS.REFERENCE,
        path: [
            [
                'recorder'
            ]
        ],
        referenceTypes: [
            'Practitioner'
        ]
    }
};

//# sourceMappingURL=searchParameters.js.map