import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
import type { Department } from './Department';
import type { User } from './User';
import type { Location } from './Location';
import type { Encounter } from './Encounter';
export declare class Procedure extends Model {
    id: string;
    completed: boolean;
    date: string;
    endTime?: string;
    startTime?: string;
    note?: string;
    completedNote?: string;
    encounterId?: string;
    locationId?: string;
    procedureTypeId?: string;
    physicianId?: string;
    anaesthetistId?: string;
    anaestheticId?: string;
    departmentId?: string;
    assistantAnaesthetistId?: string;
    timeIn?: string;
    timeOut?: string;
    encounter?: Encounter;
    location?: Location;
    department?: Department;
    leadClinician?: User;
    anaesthetist?: User;
    assistantAnaesthetist?: User;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    forResponse(): any;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
}
//# sourceMappingURL=Procedure.d.ts.map