"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "AuthPermissionError", {
    enumerable: true,
    get: function() {
        return AuthPermissionError;
    }
});
const _AuthenticationError = require("../AuthenticationError");
const _constants = require("../../constants");
let AuthPermissionError = class AuthPermissionError extends _AuthenticationError.BaseAuthenticationError {
    constructor(detail){
        super(_constants.ERROR_TYPE.AUTH_PERMISSION_REQUIRED, 'Lacks permission to authenticate', detail);
        this.status = 401;
    }
};

//# sourceMappingURL=AuthPermissionError.js.map