"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "defineWebsocketClientService", {
    enumerable: true,
    get: function() {
        return defineWebsocketClientService;
    }
});
const _socketioclient = require("socket.io-client");
const _constants = require("@tamanu/constants");
const defineWebsocketClientService = (injector)=>{
    const url = new URL(injector.config.sync.host);
    const client = (0, _socketioclient.io)(url.toString(), {
        path: _constants.WS_PATH,
        transports: [
            'websocket',
            'webtransport'
        ]
    });
    const getClient = ()=>client;
    //forward event to facility client
    client.on(_constants.WS_EVENTS.TELEGRAM_SUBSCRIBE, /**
     *
     * @param {{ contactId: string, chatId: string }} payload
     */ async ({ chatId, contactId })=>{
        const contact = await injector.models?.PatientContact.findByPk(contactId);
        if (!contact) return;
        contact.connectionDetails = {
            chatId
        };
        await contact.save();
        injector.websocketService?.emit(_constants.WS_EVENTS.TELEGRAM_SUBSCRIBE_SUCCESS, {
            contactId,
            chatId
        });
    });
    client.on(_constants.WS_EVENTS.TELEGRAM_UNSUBSCRIBE, /**
     *
     * @param {{ contactId: string }} payload
     */ async ({ contactId })=>{
        const contact = await injector.models?.PatientContact.findByPk(contactId);
        if (!contact) return;
        await contact.destroy();
        injector.websocketService?.emit(_constants.WS_EVENTS.TELEGRAM_UNSUBSCRIBE_SUCCESS, {
            contactId
        });
    });
    const emit = (eventName, ...args)=>client.emit(eventName, ...args);
    const listenOnce = (eventName, callback)=>client.once(eventName, callback);
    return {
        getClient,
        emit,
        listenOnce
    };
};

//# sourceMappingURL=websocketClientService.js.map