"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    IDENTIFIER_NAMESPACE: function() {
        return IDENTIFIER_NAMESPACE;
    },
    decodeIdentifier: function() {
        return decodeIdentifier;
    },
    isValidIdentifier: function() {
        return isValidIdentifier;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const IDENTIFIER_NAMESPACE = _config.default.hl7.dataDictionaries.patientDisplayId;
function decodeIdentifier(identifier) {
    if (typeof identifier !== 'string') {
        return [
            null,
            null
        ];
    }
    const [namespace, ...idPieces] = identifier.split('|');
    return [
        namespace || null,
        idPieces.join('|') || null
    ];
}
function isValidIdentifier(value) {
    // Yup will always run a test for the parameter, even when it's undefined
    if (!value) return true;
    const [namespace, displayId] = decodeIdentifier(value);
    return namespace === IDENTIFIER_NAMESPACE && !!displayId;
}

//# sourceMappingURL=identifier.js.map