"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EmailService", {
    enumerable: true,
    get: function() {
        return EmailService;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _formdata = /*#__PURE__*/ _interop_require_default(require("form-data"));
const _mailgun = /*#__PURE__*/ _interop_require_default(require("mailgun.js"));
const _fs = require("fs");
const _path = require("path");
const _constants = require("@tamanu/constants");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const mailgun = new _mailgun.default(_formdata.default);
const { apiKey, domain } = _config.default.mailgun;
async function getReadStreamSafe(path) {
    return new Promise((resolve, reject)=>{
        // Mailgun doesn't do any error handling internally, so we
        // take charge of opening the attachment, and just pass the
        // stream to mailgun instead of the path.
        const readStream = (0, _fs.createReadStream)(path);
        // Don't return the stream until it's actually successfully opened
        readStream.on('open', ()=>resolve(readStream));
        // Handle any errors with a reject (if this handler isn't assigned,
        // node will panic and exit regardless of any try/catch wrappers!)
        readStream.on('error', (e)=>reject(e));
    });
}
let EmailService = class EmailService {
    /**
   *
   * @param {import('mailgun.js/interfaces/Messages').MailgunMessageData} param0
   */ async sendEmail({ attachment: untypedAttachment, ...email }) {
        // no mailgun service, unable to send email
        if (!this.mailgunService) {
            return {
                status: _constants.COMMUNICATION_STATUSES.ERROR,
                error: 'Email service not found'
            };
        }
        if (!email.from) {
            return {
                status: _constants.COMMUNICATION_STATUSES.BAD_FORMAT,
                error: 'Missing from address'
            };
        }
        if (!email.to) {
            return {
                status: _constants.COMMUNICATION_STATUSES.BAD_FORMAT,
                error: 'Missing to address'
            };
        }
        if (!email.subject) {
            return {
                status: _constants.COMMUNICATION_STATUSES.BAD_FORMAT,
                error: 'Missing subject'
            };
        }
        let attachment;
        if (typeof untypedAttachment === 'string') {
            try {
                // pass mailgun readable stream instead of the path
                attachment = {
                    data: await getReadStreamSafe(untypedAttachment),
                    filename: (0, _path.basename)(untypedAttachment)
                };
            } catch (e) {
                _logging.log.error('Could not read attachment for email', e);
                return {
                    status: _constants.COMMUNICATION_STATUSES.ERROR,
                    error: 'Attachment missing or unreadable'
                };
            }
        } else {
            attachment = untypedAttachment;
        }
        try {
            const emailResult = await this.mailgunService.messages.create(domain, {
                ...email,
                attachment
            });
            return {
                status: _constants.COMMUNICATION_STATUSES.SENT,
                result: emailResult
            };
        } catch (e) {
            return {
                status: _constants.COMMUNICATION_STATUSES.ERROR,
                error: e.message,
                shouldRetry: true
            };
        }
    }
    constructor(){
        this.mailgunService = apiKey && domain ? mailgun.client({
            username: 'api',
            key: apiKey
        }) : null;
    }
};

//# sourceMappingURL=EmailService.js.map