"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const _datefns = require("date-fns");
const _dateTime = require("@tamanu/utils/dateTime");
const _chance = require("../../../chance");
const _insertEncounter = require("../../insertEncounter");
const _insertSurveyResponse = require("./insertSurveyResponse");
const _insertCovidTest = require("./insertCovidTest");
const _default = {
    setup: [
        'examiners',
        'facilitiesDepartmentsAndLocations',
        'labTestCategories',
        'programSurveyAndQuestions',
        'villages'
    ],
    run: async (store, setupData, patientId)=>{
        const testDates = [];
        for(let i = 0; i < _chance.chance.integer({
            min: 0,
            max: 3
        }); i++){
            const { id: encounterId } = await (0, _insertEncounter.insertEncounter)(store, setupData, patientId);
            const test = await (0, _insertCovidTest.insertCovidTest)(store.sequelize.models, setupData, {
                encounterId
            });
            testDates.push(test.date);
        }
        // survey responses
        for (const testDate of testDates){
            for(let i = 0; i < _chance.chance.integer({
                min: 0,
                max: 2
            }); i++){
                const { id: encounterId } = await (0, _insertEncounter.insertEncounter)(store, setupData, patientId);
                const startTime = (0, _datefns.addHours)((0, _datefns.addDays)((0, _dateTime.parseDate)(testDate), _chance.chance.integer({
                    min: 1,
                    max: 6
                })), _chance.chance.integer({
                    min: 1,
                    max: 12
                }));
                await (0, _insertSurveyResponse.insertSurveyResponse)(store.sequelize.models, setupData, {
                    encounterId,
                    startTime
                });
            }
        }
    }
};

//# sourceMappingURL=index.js.map