import React from 'react';
import { View } from '@react-pdf/renderer';
import { Box, Signature, SigningImage } from './Layout';
import { useLanguageContext } from '../pdf/languageContext';
export const SigningSection = ({ signingSrc, style, ...props })=>{
    const { getTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, {
        style: {
            flexDirection: 'column',
            justifyContent: 'flex-end',
            flex: 1,
            paddingLeft: 15,
            paddingRight: 15,
            ...style
        },
        ...props
    }, signingSrc ? /*#__PURE__*/ React.createElement(SigningImage, {
        src: signingSrc
    }) : /*#__PURE__*/ React.createElement(Box, {
        mb: 0
    }, /*#__PURE__*/ React.createElement(Box, null, /*#__PURE__*/ React.createElement(Signature, {
        text: getTranslation('pdf.signature.authorisedBy', 'Authorised by')
    })), /*#__PURE__*/ React.createElement(Box, {
        mb: 10
    }, /*#__PURE__*/ React.createElement(Signature, {
        text: getTranslation('pdf.signature.signed', 'Signed')
    })), /*#__PURE__*/ React.createElement(Box, null, /*#__PURE__*/ React.createElement(Signature, {
        text: getTranslation('pdf.signature.date', 'Date')
    }))));
};

//# sourceMappingURL=SigningSection.js.map