"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.addColumn('vds_nc_signers', 'request_sent_at', {
            type: Sequelize.DATE,
            defaultValue: null
        });
        await query.addIndex('vds_nc_signers', {
            fields: [
                'request_sent_at'
            ]
        });
        await query.addIndex('vds_nc_signers', {
            fields: [
                'deleted_at'
            ]
        });
    },
    down: async (query)=>{
        await query.removeIndex('vds_nc_signers', [
            'deleted_at'
        ]);
        await query.removeIndex('vds_nc_signers', [
            'request_sent_at'
        ]);
        await query.removeColumn('vds_nc_signers', 'request_sent_at');
    }
};

//# sourceMappingURL=060_addRequestSentAtToVdsSigner.js.map