"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query, _sequelize1) {
    await query.changeColumn('invoice_items', 'product_name', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.changeColumn('invoice_items', 'product_code', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.sequelize.query(`ALTER TABLE invoice_items ALTER COLUMN product_price DROP DEFAULT;`);
    await query.changeColumn('invoice_items', 'product_price', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: true
    });
}
async function down(query, _sequelize1) {
    await query.sequelize.query(`UPDATE invoice_items SET product_price = 0 WHERE product_price IS NULL;`);
    await query.changeColumn('invoice_items', 'product_price', {
        type: _sequelize.DataTypes.DECIMAL,
        allowNull: false
    });
    await query.changeColumn('invoice_items', 'product_code', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false
    });
    await query.changeColumn('invoice_items', 'product_name', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false
    });
}

//# sourceMappingURL=1761866461000-makeInvoiceItemFieldsNullable.js.map