import crypto from 'crypto';
import { Model } from './Model';
import type { InitOptions } from '../types/model';
export declare class Signer extends Model {
    id: string;
    countryCode: string;
    privateKey?: Buffer;
    publicKey: Buffer;
    request: string;
    requestSentAt?: Date;
    certificate?: string;
    workingPeriodStart?: Date;
    workingPeriodEnd?: Date;
    validityPeriodStart?: Date;
    validityPeriodEnd?: Date;
    signaturesIssued: number;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static findActive(): Promise<Signer | null>;
    /**
     * Fetches pending signer, those without certificates
     * Errors if multiple pending signers are found
     * return {Signer} The pending signer, or null if there's none
     */
    static findPending(): Promise<Signer | null>;
    /**
     * @return {boolean} True if the signer is active (can be used).
     */
    isActive(): boolean;
    decryptPrivateKey(keySecret: string): crypto.KeyObject;
}
//# sourceMappingURL=Signer.d.ts.map