import { buildEncounterLinkedSyncFilterJoins } from './buildEncounterLinkedSyncFilter';
import { buildSyncLookupSelect } from './buildSyncLookupSelect';
/**
 * Helper to determine if a facility_id should be populated in sync lookup
 * Only populates facility_id when the encounter is from a sensitive facility
 * This ensures sensitive encounters are only synced to their originating facility
 */ export const ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE = `
    CASE
      WHEN facilities.is_sensitive = TRUE THEN facilities.id
      ELSE NULL
    END
  `;
export async function buildEncounterLinkedLookupSelect(model, extraSelects) {
    return await buildSyncLookupSelect(model, {
        patientId: 'encounters.patient_id',
        facilityId: ADD_SENSITIVE_FACILITY_ID_IF_APPLICABLE,
        ...extraSelects
    });
}
export function buildEncounterLinkedLookupJoins(model, joinsToEncounters) {
    return buildEncounterLinkedSyncFilterJoins([
        model.tableName,
        ...joinsToEncounters || [
            'encounters'
        ],
        'locations',
        'facilities'
    ]);
}
export async function buildEncounterLinkedLookupFilter(model) {
    return {
        select: await buildEncounterLinkedLookupSelect(model),
        joins: buildEncounterLinkedLookupJoins(model)
    };
}

//# sourceMappingURL=buildEncounterLinkedLookupFilter.js.map